package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.core.WebChatMedia;
import com.avaya.ccs.javafxrefclient.Logger;

public class PagePushRequest extends InteractionRequest{

	private static final Logger LOG = Logger.getLogger(PagePushRequest.class);
	
	String interactionId;
	String url;
	
	public PagePushRequest(String interactionId, String url) {
		super(LOG, interactionId);
		this.interactionId=interactionId;
		this.url=url;
	}

	/**
     * The call method executes on the outgoingRequest thread
     *
     * @return
     * @throws Exception
     */
    @Override
	protected Object call() throws Exception {

    	String methodName = "call() ";
        LOG.info(methodName + "+");	        
        ((WebChatMedia)getInteraction().getMedia()).sendPagePushUrl(url);
        LOG.info(methodName + "-"); 
    	LOG.warn("call", "Not Implemented.");
        return null;
	}

}
